/**
  ******************************************************************************
  * @file    cp_frame.h 
  * @author  Ruediger R. Asche
  * @version V1.0.0
  * @date    July 14, 2016
  * @brief   include file for level 2 definitions of the sample communication protocol
  ******************************************************************************
  * @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, THE AUTHOR SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  ******************************************************************************  
  */ 


#ifndef CP_FRAME_H
#define CP_FRAME_H

#define CP_FRAMESTART (0x23)
#define CP_ESCAPE     (0x20)

#define TRANSPOSE(char) (~char)

#define CP_MAXSHORTBUFLEN (CP_FRAMESTART+1) // test

#define CP_FSM_STATE_CHANGE(fsm,x) fsm->m_FSM = x;

typedef enum
{
    CP_FSM_IN_SCANNING = 0,
    CP_FSM_IN_FRAME_START_FOUND,
    CP_FSM_IN_READ_LEN1,
    CP_FSM_IN_READ_LEN2,
    CP_FSM_IN_READ_LEN3,
    CP_FSM_IN_READING_PAYLOAD,
    CP_FSM_IN_ABORT
} CP_FSM_IN_FSM_STATES;

typedef enum
{
    CP_STATUSCODE_SUCCESS,
    CP_STATUSCODE_NOMEM,
    CP_STATUSCODE_CORRUPT,
    CP_STATUSCODE_CONNLOSS,
    CP_STATUSCODE_AUTHFAIL,
    CP_STATUSCODE_FATAL,
    CP_STATUSCODE_NODATA,
    CP_STATUSCODE_PACKET_NOT_ACKED
} CP_STATUSCODE;

typedef enum
{
    CP_RESPONSE_ACK = 0,
    CP_RESPONSE_GENERIC_NAK
} CP_RESPONSECODES;

#define CP_FLAGS_ESCAPEFOUND (1 << 0)

#define CP_CHECKFORTRANSPOSITION(mp_char,mp_fsmstruct,mp_action) \
{ \
    if (mp_fsmstruct->m_Flags & CP_FLAGS_ESCAPEFOUND) \
    { \
        mp_fsmstruct->m_Flags &= ~CP_FLAGS_ESCAPEFOUND; \
        switch (mp_char) \
        { \
            case (unsigned char)TRANSPOSE(CP_ESCAPE): case (unsigned char)TRANSPOSE(CP_FRAMESTART): \
                mp_char = TRANSPOSE(mp_char); break; \
            default: goto ResetFSM; \
        } \
    } \
    else \
    { \
        if (mp_char == CP_ESCAPE) \
        { \
            mp_fsmstruct->m_Flags |= CP_FLAGS_ESCAPEFOUND; \
        } \
    } \
    if (!mp_fsmstruct->m_Flags & CP_FLAGS_ESCAPEFOUND) \
        mp_action \
}

typedef struct CP_FSM_IN
{
    unsigned long  m_PendingReadLen;
    unsigned long  m_CharsRead;
    CP_FSM_IN_FSM_STATES m_FSM;                           // receiver FSM.
    unsigned short m_Flags;                         // see CP_FLAGS_XXX above
    unsigned char *m_InPtr;
    unsigned char m_ShortBuf[CP_MAXSHORTBUFLEN];    
} CP_FSM_IN, *PCP_FSM_IN;

typedef CP_STATUSCODE (*CP_INCOMINGSINGLETLVPACKETCALLBACK) (unsigned long p_Tag, unsigned long p_Len,unsigned char *p_MarshalledVal);

#endif

